<title>My Jobs - Best Leearning</title>
@extends('user.layouts.master')
@section('css')
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://moneyupwork.com/resources/css/argon.css?v=1.1.0" type="text/css">
    <link rel="stylesheet" href="https://moneyupwork.com/resources/css/myapp.css" type="text/css">
    <link rel="stylesheet" href="https://moneyupwork.com/resources/css/bttn.css" type="text/css">
    <style>
        .shadow-sm {
            display: none !important;
        }

        .table th {
            background-color: rgba(250, 250, 250, 1); 
            color: #000066; 
            font-size: 12px;
        }
    
        .table-no-vertical-border th,
        .table-no-vertical-border td {
            border-left: none;  
            border-right: none; 
            border-color: rgba(0, 0, 0, 0.1); 
        }
        .table tbody tr:hover {
            cursor: pointer;
            opacity: 0.6;
        }
        
        .arv-job {
           color: blue;
           font-weight:bold;
        }
        
    </style>
@endsection
@section('user-content')
    @if(session('resume_success'))
        <div class="alert alert-success" style="font-weight:bold;">
            <i class="fas fa-check"></i>
            <span id="resumeSuccessMessage" class="ms-3">Resume Success</span>
            <button type="button" class="close" onclick="closeResumeMessage()">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

<section>
    <div class="card mt-2">
        <div class="card-header">
    <div class="card-title text-center" style="font-weight: 500; color: #2ECC71; font-size: 20px;">My Posted Jobs</div>
   
        </div>
        <div class="card-body">
            <!--<div class="notice-box mb-3">
                <marquee bgcolor="transparent" style="padding: 5px;border-radius: 5px;border: 1px solid blue;margin-top: 5px" behavior="scroll">
                    <a style="font-size:15px; color: #000066">
                        <i class="fe fe-link me-2" aria-hidden="true"></i>Please review all proves within 48 hours or proves will be approved automatically
                    </a>
                </marquee>
            </div>-->
            
            @if ($datas->isEmpty())
                <div class="text-center py-3">
                    <p>You Have No Job</p>
                </div>
            @else
            <div class="table-responsive active">
                <table class="table table-bordered text-nowrap table-no-vertical-border table-flush" id="example1">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col border-bottom-0" width="5%">JOB ID</th>
                            <th scope="col border-bottom-0">JOB NAME</th>
                            
                            <th scope="col border-bottom-0" width="8%">PROGRESS</th>
                            <!--<th scope="col border-bottom-0" width="8%">TASK PRICE</th>-->
                            
                            <th scope="col border-bottom-0" width="8%">COST</th>
                                                        <!--<th scope="col border-bottom-0" width="5%">Work Proof</th>-->
                            
                            <th scope="col border-bottom-0" width="8%">STATUS</th>
                            
                            <th scope="col border-bottom-0" width="8%">ACTION</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                        @foreach ($datas as $key => $data)
                            <tr>
                                <td style="vertical-align: middle;">{{ $data->code }}</td>
                                @if ($data->status == 1)
                                <td class="arv-job" style="vertical-align: middle;"><a href="{{ route('user.job-working-proves', $data->code) }}">{{ $data->title }}</a></td>
                                @else
                                <td style="vertical-align: middle;">{{ $data->title }}</td>
                                @endif
                                <td style="vertical-align: middle;">{{ complete_work_this_job($data->id) }} OF {{ $data->worker_need }}</td>
                                <!--<td>{{ $data->each_worker_earn }}$</td>-->
                               
                                <td style="vertical-align: middle;">{{ $data->budget }}$</td>
                                    
                                <td style="vertical-align: middle;">
                                    @if ($data->pause == 1)
                                        <span class="badge badge-dot mr-4">
                                            <i class="bg-gradient-red"></i>
                                            <span class="text-black">Paused</span>
                                        </span>
                                    @elseif ($data->worker_need <= $data->worker_confirmed)
                                        <span class="badge badge-dot mr-4">
                                            <i class="bg-gradient-blue"></i>
                                            <span class="text-black">Complete</span>
                                        </span>
                                    @elseif ($data->status == 1)
                                        <span class="badge badge-dot mr-4">
                                            <i class="bg-gradient-green"></i>
                                            <span class="text-black">Active</span>
                                        </span>
                                    @elseif ($data->status == 2)
                                        <span class="badge badge-dot mr-4">
                                            <i class="bg-gradient-red"></i>
                                            <span class="text-black">Rejected</span>
                                        </span>
                                    @else
                                        <span class="badge badge-dot mr-4">
                                            <i style="background-color: #F1C40F;"></i>
                                            <span class="text-black">Pending</span>
                                        </span>
                                    @endif
                                </td>
                                
                                <td style="vertical-align: middle;">
                                    <!--@if ($data->status == 1)
                                        @if ($data->worker_need != $data->worker_confirmed && $data->pause != 1)
                                            @if(job_ready_for_boost($data->id) == 1)
                                                <a href="javascript:;" class="btn btn-sm btn-primary" onclick="boostJob({{ $data->id }})">Boost</a>
                                            @else
                                                <a href="javascript:;" class="btn btn-sm btn-primary" onclick="boostJob({{ $data->id }})">{{remain_interval_for_boost($data->id)}}m</a>
                                            @endif
                                        @endif
                                    @endif-->
                                    @if ($data->status == 1)
                                        <a href="{{ route('user.job-working-proves', $data->code) }}" class="btn btn-sm btn-info bttn">Proves</a>
                                    @endif
                                    
                                    <!--@if ($data->worker_need <= $data->worker_confirmed)
                                        <a href="javascript:;" class="btn btn-sm btn-warning" onclick="updateJobWorker({{ $data->id }})">Update</a>
                                        <!--<a href="#" class="btn btn-sm btn-danger" onclick="confirmDelete('{{ route('user.job-delete', $data->id) }}')">Delete</a>
                                    @endif-->
                                    
                                    @if ($data->pause == 1)
                                        <a href="{{ route('user.start-job', $data->id) }}" class="btn btn-sm btn-twitter bttn">Resume</a>
                                    @endif
                                        <a href="{{ route('user.my-job-details', $data->code) }}" class="btn btn-sm btn-primary bttn">Details</a>
                                   <!-- @if ($data->status == 2)
                                        <a href="#" class="btn btn-sm btn-danger" onclick="confirmDelete('{{ route('user.job-delete', $data->id) }}')">Delete</a>
                                    
                                    @endif-->
                                </td>
                            </tr>
                            
                            @if(job_ready_for_boost($data->id) == 1)
                                <div class="modal fade" id="boost_job_{{ $data->id }}" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <form action="{{ route('user.job-boosting-update', $data->id) }}" method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Boost For "{{ $data->title }}"</h5>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <select class="form-control" name="boost_charge" required>
                                                            <option value="">Select One</option>
                                                            @foreach(boost_charges() as $boost_charge)
                                                                <option value="{{$boost_charge->id}}">{{$boost_charge->duration}} Minutes - ${{$boost_charge->charge}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
    
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="boostJobModalClose({{ $data->id }})">Close</button>
                                                    <button type="submit" class="btn btn-primary">Submit</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            @endif

                            @if ($data->worker_need <= $data->worker_confirmed)
                                <div class="modal fade" id="worker_need_{{ $data->id }}" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <form action="{{ route('user.job-work-need-update', $data->id) }}" method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Update Worker Need</h5>
                                                </div>
                                                <div class="modal-body">
                                                    <p class="text-green"><h5 style="color:blue;">Worker Earn=${{ number_format($data->each_worker_earn, 4) }}</p>
                                                    <div class="form-group col-lg-12 col-md-12 col-12">
                                                        <input type="number" class="form-control" id="worker_input_{{ $data->id }}" name="worker" value="0" min="0" required>
                                                        <br>
                                                        <p id="cost_display_{{ $data->id }}" class="" style="padding: 5px;font-weight:bold"></p> 
                                                    </div>
                                                </div>
                                
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="updateJobWorkerMosdalClose({{ $data->id }})">Close</button>
                                                    <button type="submit" class="btn btn-primary bttn">Submit</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            @endif
                       @endforeach
                    </tbody>
                </table>
               {{-- $datas->links() --}}
            </div>
            @endif
        </div>
    </div>
</section>
@endsection
@section('js')
    <script>
        function updateJobWorker(id){
            $('#worker_need_'+id).modal('show');
        }

        function updateJobWorkerMosdalClose(id){
            $('#worker_need_'+id).modal('hide');
        }
        
        function boostJob(id){
            $('#boost_job_'+id).modal('show');
        }

        function boostJobModalClose(id){
            $('#boost_job_'+id).modal('hide');
        }
        

        function confirmDelete(url) {
            var result = confirm("Are you sure you want to delete?");
            if (result) {
                // If the user clicks "OK" in the confirmation dialog, redirect to the delete URL
                window.location.href = url;
            }
        }
        
        function closeResumeMessage() {
            var resumeMessage = document.querySelector('.alert-success');
            resumeMessage.style.display = 'none';
        }
        
    </script>
@endsection
